#*******************************************************************************
# Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/ 
#	
#	
#	   Redistribution and use in source and binary forms, with or without 
#	   modification, are permitted provided that the following conditions 
#	   are met:
#	 
#	   Redistributions of source code must retain the above copyright 
#	   notice, this list of conditions and the following disclaimer.
#	 
#	   Redistributions in binary form must reproduce the above copyright
#	   notice, this list of conditions and the following disclaimer in the 
#	   documentation and/or other materials provided with the   
#	   distribution.
#	 
#	   Neither the name of Texas Instruments Incorporated nor the names of
#	   its contributors may be used to endorse or promote products derived
#	   from this software without specific prior written permission.
#	 
#	   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
#	   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
#	   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#	   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
#	   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
#	   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
#	   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#	   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#	   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
#	   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#	   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#	 
#	 
#*******************************************************************************

#*******************************************************************************
# FILENAME
#   libusb_os.mk
#
# DESCRIPTION
#   This GNU makefile contains OS specific compiler & linker customizations.
#
# NOTES
#   This GNU makefile assumes the GNU bash shell and utilities are available.
#
#*******************************************************************************

# Build tools.
LD  := g++
G++ := g++
GCC := gcc

# C preprocessor defines.
DEFINES := 

MACOSX_SDK  := /Applications/Xcode.app/Contents/Developer/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.11.sdk

# 
# MacOSX specific compiler and linker settings for shared libraries.
#

ifeq "$(TARGET_TYPE)" "sharedlibrary"
DEFINES     := $(DEFINES)
CFLAGS      := -isysroot $(MACOSX_SDK) -mmacosx-version-min=10.9 -fPIC -Wall
LDFLAGS     := -Wl,-syslibroot,$(MACOSX_SDK) -mmacosx-version-min=10.9 -dynamiclib 
LDFLAGS     := $(LDFLAGS) -install_name @rpath/$(TARGET_NAME)
LDCHECK     := -Wl,-syslibroot,$(MACOSX_SDK) -mmacosx-version-min=10.9 
LIBS        :=  
endif

#
# Add -rpaths to LDFLAGS for all executables and libraries
#

LDFLAGS     := $(LDFLAGS) -Wl,-rpath,@loader_path/ \
                          -Wl,-rpath,@loader_path/../../common/bin 
LDCHECK     := $(LDCHECK) -Wl,-rpath,@loader_path/ \
                          -Wl,-rpath,@loader_path/../../common/bin 

#
# Add in the architecture specific flags
#

CFLAGS     := $(CFLAGS) -arch $(BUILD_ARCH) 
LDFLAGS    := $(LDFLAGS) -arch $(BUILD_ARCH) 
LDCHECK    := $(LDCHECK) -arch $(BUILD_ARCH) 

# Request compiler warnings and errors with -Wall and -Wextra.
# Th -Wall has one of its warnings suppressed by -Wno-format.
# That is because it reports unfixable differences between function
# arguments types in the stdio.h header and typedefs in the inttypes.h header.
# The -Wextra is requested using its old name of -W because that is required by old gcc versions.
CFLAGS     := $(CFLAGS) -Wall -Wno-format -W

# Set the debug build flag for Debug builds
ifeq "$(BUILD_TYPE)" "Debug"
# Set it in the compiler
CFLAGS     := $(CFLAGS) -g
LDFLAGS    := $(LDFLAGS) -g
LDCHECK    := $(LDCHECK) -g
DEFINES    := $(DEFINES) -D _DEBUG
else
DEFINES    := $(DEFINES) -D NDEBUG
endif

# Choose to build C++ instead of C.
CFLAGS     := $(CFLAGS) -x c++
LIBS       := $(LIBS) -lstdc++

# -- END OF FILE --
