
#include "ti_msp_dl_config.h"
#include "No_Mcu_Ganv_Grayscale_Sensor_Config.h"
#include "delay.h"
#include "adc.h"
#include "led.h"
#include "uart.h"
#include "stdio.h"
#include "key.h"
#include "flash.h"
/*
 * =======================================================
 * Ӳӳ (Hardware Pinout Map)
 * =======================================================
 * 
 * ----------------------------
 * LED (LED Control Pins)
 * ----------------------------
 * PA18  -> LED1        // ָʾ1
 * PA17  -> LED2        // ָʾ2
 * PA16  -> LED3        // ָʾ3
 * PA10  -> LED4        // ָʾ4
 * PA9   -> LED5        // ָʾ5
 * PA8   -> LED6        // ָʾ6
 * PA7   -> LED7        // ָʾ7
 * PA6   -> LED8        // ָʾ8
 * PA11  -> ERR_LED     // ״ָ̬ʾ
 * PA12  -> KEY_LED     // ״ָ̬ʾ
 * 
 * ----------------------------
 * û (User Input Pin)
 * ----------------------------
 * PA22  -> KEY         // û
 * 
 * ----------------------------
 * MCUӿ
 * (Dedicated Sensor Interface)
 * ----------------------------
 * PA15  -> AD0         // ַͨ0
 * PA14  -> AD1         // ַͨ1
 * PA13  -> AD2         // ַͨ2
 * PA26  -> ERR         // ź
 * PA27  -> OUT         // ģź(ADC)
 * 
 * =======================================================
 */



/*                  ģתͻرȽ(ʩش)ʾͼ               
 *          /\
 *   Digital |     
 *           |
 *        0  |                 +----------------+--------------
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |
 *           |                 |                |     
 *         1 |    -------------+----------------+
 *      -----+----------------------------------------------------------> analog
 *           |   0             1/3              2/3            1 
 *           |               Һ             Ұ            
 *               Calibrated    Gray             Gray           Calibrated
 *               black         black            white          white
 */



// ȫֱ
unsigned short Anolog[8] = {0};    // 洢ǰģֵ
unsigned short white[8] = {0};     // 洢ɫУ׼ֵ 
unsigned short black[8] = {0};     // 洢ɫУ׼ֵ
unsigned short Normal[8];          // һֵ

No_MCU_Sensor sensor;              // ݽṹ
unsigned char Digtal;              // ֵ

volatile int8_t index=-1;
// Ĵṹ
typedef struct {
    unsigned char Digital;     // ֵ
} DigitalRegister;

// ¼Ĵֵø±־
void UpdateRegister(DigitalRegister *reg, unsigned char new_value) {
    if (reg->Digital != new_value) {
        reg->Digital = new_value;
    }
}

DigitalRegister reg;
// ʼ
void QualityCheck(void){
	configure_QualityCheck_GPIO();
	Tick_delay(100);
	if((DL_GPIO_readPins(LED_PORT, LED_ERR_PIN) > 0)&&(DL_GPIO_readPins(GRAY_IN_PORT, GRAY_IN_IN_KEY_PIN) > 0)){
		for(uint8_t i=0;i<20;i++){
			LED_on(LED_ERR);
			LED_on(LED_KEY);
			if(Digtal==0xFF){
				Digtal=0x7F;
			}
			else{
				Digtal=0xFF;
			};
			LED_setByDigital(Digtal);
			Tick_delay(100);
		}
	}
	restore_QualityCheck_GPIO();
}
int main(void)
{
    // ʼϵͳ
    SYSCFG_DL_init();
	
    // ʼ룬ʵʹпѡע
		Tick_delay(100);
		QualityCheck();
	
    // ʼLED
    LED_init();
    
    /* DMA - ADCݴ */
    // DMAԴַ(ADC洢)
    DL_DMA_setSrcAddr(DMA, DMA_CH0_CHAN_ID, (uint32_t) &ADC0->ULLMEM.MEMRES[0]);
    // DMAĿַ(ADC_VALUE)
    DL_DMA_setDestAddr(DMA, DMA_CH0_CHAN_ID, (uint32_t) &ADC_VALUE[0]);		
    // ʹDMAͨ
    DL_DMA_enableChannel(DMA, DMA_CH0_CHAN_ID);;
    // ADCת
    DL_ADC12_startConversion(ADC_VOLTAGE_INST);
    
    // ʹܰж
    NVIC_EnableIRQ(GPIO_MULTIPLE_GPIOA_INT_IRQN);
		
		DL_TimerG_startCounter(TIMER_0_INST);
		NVIC_EnableIRQ(TIMER_0_INST_INT_IRQN);
	
    // Flash洢ȡУ׼ֵ
    readWhiteFromFlash();  // ȡɫУ׼ֵ
    readBlackFromFlash();  // ȡɫУ׼ֵ

    // ʹУ׼ֵʼ
    No_MCU_Ganv_Sensor_Init(&sensor, white, black);

    //MCUҶȴӲҪʱ
    Tick_delay(100);
    state.value=KEY_IDLE;
		
    /* Ӧóѭ */
    while (1) {
        if (state.value == KEY_IDLE||state.value == KEY_DISABLE||state.value == KEY_WAIT_LOSS ) {
            // ģʽ(У׼״̬)
            
            // ִʱĴ
            No_Mcu_Ganv_Sensor_Task_Without_tick(&sensor);
            
            // Ӵȡǰģֵ
            Get_Anolog_Value(&sensor, Anolog);
            
            // ģתΪ
            Digtal = Get_Digtal_For_User(&sensor);
					
        } else {
            // У׼ģʽ - 0·LEDƹر
            Digtal = 0;
        }
				
        // 
        Key_Process();
        
        // ֵLEDʾ
        LED_setByDigital(Digtal);
				UpdateRegister(&reg, Digtal);
        
        // KEYERR LED״̬
        LED_KEY_Blink_Update();
				if(state.value!=KEY_LIGHT_ERROR){
					// LEDƣڴ־״̬
					bool err_state = long_err_flag ? 1 :
													(DL_GPIO_readPins(GRAY_IN_PORT, GRAY_IN_IN_ERR_PIN) > 0);								
					err_state ? LED_on(LED_ERR) : LED_off(LED_ERR);
				}
				else{
					LED_ERR_Blink_Update();
				}
    }
}
/**
 * @brief ⲿжϴCLKͰ
 * @note  ⵽Чkey_pressed־
 */
void GROUP1_IRQHandler(void)
{
	    // ȡGroup1жϼĴжϱ־λ
    uint32_t pending = DL_GPIO_getPendingInterrupt(GPIOA);
	
    if(pending == GRAY_IN_IN_KEY_IIDX){
            /*  */
            if ((Tick - last_key_time) < DEBOUNCE_TIME_MS) {
                return;
            }
            /* ȷϰ */
            if (DL_GPIO_readPins(GRAY_IN_PORT, GRAY_IN_IN_KEY_PIN) == 0) {
                key_pressed = 1;
								long_pressed_key_time=Tick;
                last_key_time = Tick;
            }
    }
		if(pending == Serial_CLK_IIDX){
				 DL_TimerG_setTimerCount(TIMER_0_INST, 0);
				(reg.Digital & (1 << index)) ? DL_GPIO_setPins(Serial_PORT, Serial_DAT_PIN) : DL_GPIO_clearPins(Serial_PORT, Serial_DAT_PIN);
				index++;
				if(index==8){//յ9ʱӺ󣬸һ֡
					index=0;
				}
		}
}