#*******************************************************************************
# Copyright (C) 2015-2020 Texas Instruments Incorporated - http://www.ti.com/ 
#	
#	
#	   Redistribution and use in source and binary forms, with or without 
#	   modification, are permitted provided that the following conditions 
#	   are met:
#	 
#	   Redistributions of source code must retain the above copyright 
#	   notice, this list of conditions and the following disclaimer.
#	 
#	   Redistributions in binary form must reproduce the above copyright
#	   notice, this list of conditions and the following disclaimer in the 
#	   documentation and/or other materials provided with the   
#	   distribution.
#	 
#	   Neither the name of Texas Instruments Incorporated nor the names of
#	   its contributors may be used to endorse or promote products derived
#	   from this software without specific prior written permission.
#	 
#	   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
#	   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
#	   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#	   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
#	   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
#	   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
#	   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#	   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#	   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
#	   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#	   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#	 
#	 
#*******************************************************************************

#*******************************************************************************
# FILENAME
#   libusb_rules.mk
#
# DESCRIPTION
#   This GNU makefile contains compiler and linker rules.
#
# NOTES
#   This GNU makefile assumes the GNU bash shell and utilities are available.
#
#*******************************************************************************

# Prefix/Postfix the C and C++ files with the object directory and file extension.
OBJS_C   := $(patsubst %,$(OUTPUT_DIR)/%$(OBJECT_EXT),$(FILE_C))
OBJS_CPP := $(patsubst %,$(OUTPUT_DIR)/%$(OBJECT_EXT),$(FILE_CPP))
OBJECTS  := $(OBJS_C) $(OBJS_CPP)

# Rules to build everything.
.PHONY: all
all: first_all $(PRODUCT_DIR)/$(TARGET_NAME) copy

# Rule to start all builds.
.PHONY: first_all
first_all:
	@echo "Starting:  $(notdir $(TARGET_NAME)) ($(BUILD_ARCH) $(BUILD_TYPE))"
	@if test ! -d $(OUTPUT_DIR);  then mkdir -p $(OUTPUT_DIR); fi
	@if test ! -d $(PRODUCT_DIR); then mkdir -p $(PRODUCT_DIR); fi

# Rule to clean everything.
# Clean rule may be expanded on in project makefiles.
.PHONY: clean
clean:: first_all
	@echo "Cleaning:  $(notdir $(TARGET_NAME)) ($(BUILD_ARCH) $(BUILD_TYPE))"
	@find $(VPATH) -name '*~' -print0 | xargs -0 rm -f
	@rm -f $(PRODUCT_DIR)/$(TARGET_NAME)
	@rm -f $(OUTPUT_DIR)/*

# Rule to comment about cleaning.
.PHONY: first_clean
first_clean:
	@echo "Cleaning:  $(notdir $(TARGET_NAME)) ($(BUILD_ARCH) $(BUILD_TYPE))"

#
# The pattern rules.
#

# Dummy copy rule to be expanded on in project makefiles.
copy::

# Rule to copy result to product directory
$(PRODUCT_DIR)/$(TARGET_NAME): $(OUTPUT_DIR)/$(TARGET_NAME) 
	@echo "Copying:   $(notdir $@)" 
	@cp -f $(OUTPUT_DIR)/$(TARGET_NAME) $(PRODUCT_DIR)/

# Rule to link into the target file.
$(OUTPUT_DIR)/$(TARGET_NAME): $(OBJECTS)
	@echo "Linking:   $(notdir $@) ($(BUILD_ARCH) $(BUILD_TYPE))"
	@$(LD) $(LDFLAGS) $(OBJECTS) $(LIBS) -o $@ 

# Rule to build C object files.
$(OUTPUT_DIR)/%$(OBJECT_EXT): %.c
	@echo "Compiling: $(notdir $<)"
	@$(GCC) $(CFLAGS) $(INCLUDES) $(DEFINES) \
	    -c $< -o $(OUTPUT_DIR)/$*$(OBJECT_EXT) \
	    -Wp,-MMD,$(OUTPUT_DIR)/$*$(DEPEND_EXT)

# Rule to build C++ object files.
$(OUTPUT_DIR)/%$(OBJECT_EXT): %.cpp
	@echo "Compiling: $(notdir $<)"
	@$(G++) $(CFLAGS) $(CPPFLAGS) $(INCLUDES) $(DEFINES) \
	    -c $< -o $(OUTPUT_DIR)/$*$(OBJECT_EXT) \
	    -Wp,-MMD,$(OUTPUT_DIR)/$*$(DEPEND_EXT)

# Include C & C++ dependency files.
ifneq "$(MAKECMDGOALS)" "clean"
-include $(patsubst %$(OBJECT_EXT),%$(DEPEND_EXT),$(OBJECTS))
endif

#
# The suffix rules are disabled.
#
print-%  : ; @echo $* = $($*)
.SUFFIXES:

# -- END OF FILE --
