#*******************************************************************************
# Copyright (C) 2015 Texas Instruments Incorporated - http://www.ti.com/ 
#	
#	
#	   Redistribution and use in source and binary forms, with or without 
#	   modification, are permitted provided that the following conditions 
#	   are met:
#	 
#	   Redistributions of source code must retain the above copyright 
#	   notice, this list of conditions and the following disclaimer.
#	 
#	   Redistributions in binary form must reproduce the above copyright
#	   notice, this list of conditions and the following disclaimer in the 
#	   documentation and/or other materials provided with the   
#	   distribution.
#	 
#	   Neither the name of Texas Instruments Incorporated nor the names of
#	   its contributors may be used to endorse or promote products derived
#	   from this software without specific prior written permission.
#	 
#	   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
#	   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
#	   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
#	   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
#	   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
#	   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
#	   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
#	   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
#	   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
#	   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
#	   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#	 
#	 
#*******************************************************************************

#*******************************************************************************
# FILENAME
#   libusb_variables.mk
#
# DESCRIPTION
#   This GNU makefile contains directory, file and prefix/extension variables.
#
# NOTES
#   This GNU makefile assumes the GNU bash shell and utilities are available.
#
#*******************************************************************************

# Set the BUILD_TYPE to "Release" if not already set to "Debug"
ifndef BUILD_TYPE
BUILD_TYPE := Release
else
override $(BUILD_TYPE) := $(shell echo $(BUILD_TYPE) | sed s/debug/Debug/)
ifneq "$(BUILD_TYPE)" "Debug"
override $(BUILD_TYPE) := Release
endif
endif

# Set the BUILD_ARCH to "i386" if not already set to "x86_64"
ifndef BUILD_ARCH
BUILD_ARCH := i386
else
ifneq "$(BUILD_ARCH)" "x86_64"
override $(BUILD_ARCH) := i386
endif
endif

# Retrieve system name from shell
OS := $(shell uname)

# Standard subdirectory for linux specific files.
# (Be sure that any OS specific directories are listed
# before their root directories in VPATH and INCLUDES.)
OS_DIR := linux

# Set the PRODUCT_DIR to default emupack build location if not already set
ifndef PRODUCT_DIR
PRODUCT_DIR := $(MAKE_DIR)/../../../../product/emupack/build/$(OS_DIR)/$(BUILD_ARCH)/$(BUILD_TYPE)/ccs_base/common/bin
endif

# The extensions for intermediate dependancy and object files.
DEPEND_EXT := .d
OBJECT_EXT := .o

# The root directory for libftdi 
LIBUSB_DIR  := ../

# The higher level directories.
SOURCE_DIR    := $(LIBUSB_DIR)/source/libusb
BUILD_DIR     := $(LIBUSB_DIR)/build/$(OS_DIR)
OUTPUT_DIR    := $(MAKE_DIR)/$(BUILD_ARCH)/$(BUILD_TYPE)

# The source directories.
VPATH         := 

# The include directories.
INCLUDES      :=

# -- END OF FILE --
