#include "ti_msp_dl_config.h"
#include "No_Mcu_Ganv_Grayscale_Sensor_Config.h"
#include "delay.h"
#include "adc.h"
#include "uart.h"
#include "stdio.h"
#include "key.h"
#include "L298N.h"
/*Դ벻ṩ֧֣СڸΪȺѺý*/
/**
 * ŷ˵:
 * PA6  - MOTOR_A1 (A1)
 * PA7  - MOTOR_A2 (A2)
 * PA8  - MOTOR_B1 (B1)
 * PA9  - MOTOR_B2 (B2)
 * PA12 - LED_Err (ָʾ)
 * PA13 - Gray_Address_P2 (MCUַλ2)
 * PA14 - Gray_Address_P1 (MCUַλ1)
 * PA15 - Gray_Address_P0 (MCUַλ0)
 * PA16 - LED_Key (ָʾ)
 * PA17 - KEY_IN2 (2½ж)
 * PA18 - KEY_IN1 (1½ж)
 * PA19 - SWDIO (Խӿ)
 * PA20 - SWCLK (Խӿʱ)
 * PA22 - UART0_RX (0)
 * PA23 - UART0_TX (0)
 * PA25 - ADC0_CH2 (ADCͨ2룬MCUOUT)
**/
// ȫֱ
unsigned short Anolog[8] = {0};      // 洢ǰģֵ
unsigned short white[8] = {1155,2009,1528,2344,2320,1757,1721,1420}; // 洢ɫУ׼ֵ 
unsigned short black[8] = {67,72,72,72,73,74,73,64};     // 洢ɫУ׼ֵ
unsigned short Normal[8];          // һֵ
No_MCU_Sensor sensor;              // ݽṹ
unsigned char Digtal;							 // 
/**
  * @brief  ַ
  * @param  ch: Ҫ͵ַ
  * @param  stream: ļָ
  * @retval ͵ַ
  */
int fputc(int ch, FILE *stream)
{
    // 0æʱȴæʱٷʹַ
    while (DL_UART_isBusy(UART_0_INST) == true) {}
    DL_UART_transmitData(UART_0_INST, ch);
    return ch;
}

/**
  * @brief  Ƕƫ
  * @param  Normal: 8unsigned short field1׵׺ڳ 0ڵװ׳
  * @retval õĹһֵ ֵ۷Χ-7*1024~7*1024
  * @note   㲽裺
  *         1. ÿݳӦȨֵ(-7,-5,-3,-1,1,3,5,7)
  *         2. Ȩ
  *         3. ԭʼݺ
  *         4. üȨͳԭʼݺ͵õֵ
  */
int32_t CalculateNormalizedValue(unsigned short Normal[8],uint8_t field)
{
    // Ȩֵ飬ҶӦ-7,-5,-3,-1,1,3,5,7
    const short weights[8] = {-7, -5, -3, -1, 1, 3, 5, 7};
    
    int32_t weighted_sum = 0;          // Ȩ
    int32_t original_sum = 0; // ԭʼݺ
    static int last_value = 0;   // һεֵ
    
    // Ȩͺԭʼݺ
    for (int i = 0; i < 8; i++) {
				weighted_sum += 1024*(field?(4096-Normal[i]) * weights[i]:Normal[i] * weights[i]);  // ÿݳԶӦȨֵ
				original_sum += field?(4096-Normal[i]):Normal[i];               // ۼԭʼ
    }
    
    // 㲢عһֵ
    if (original_sum != 0) { // 0
        last_value = weighted_sum / original_sum;
        return last_value;
    } else {
        return last_value; // ԭʼݺΪ0һεֵ
    }
}

/**
  * @brief  
  */
int main(void)
{
    // ʼϵͳ
    SYSCFG_DL_init();
    
    /* DMA - ADCݴ */
    // DMAԴַ(ADC洢)
    DL_DMA_setSrcAddr(DMA, DMA_CH0_CHAN_ID, (uint32_t) &ADC0->ULLMEM.MEMRES[0]);
    // DMAĿַ(ADC_VALUE)
    DL_DMA_setDestAddr(DMA, DMA_CH0_CHAN_ID, (uint32_t) &ADC_VALUE[0]);		
    // ʹDMAͨ
    DL_DMA_enableChannel(DMA, DMA_CH0_CHAN_ID);
    // ADCת
    DL_ADC12_startConversion(ADC_VOLTAGE_INST);
    
    // ʹУ׼ֵʼ
    No_MCU_Ganv_Sensor_Init(&sensor, white, black);
    
    printf("Hello\n");
    
    // 򿪰ж
    NVIC_EnableIRQ(KEY_INT_IRQN);
    
    // ȴС
    while (key_start_pressed == 0) {
        Tick_delay(1);
    }
    
    // ʱж
    NVIC_EnableIRQ(TIMER_0_INST_INT_IRQN);
    DL_Timer_startCounter(TIMER_0_INST);
    
    /* Ӧóѭ */
    while (1) {
        // ݴ
        No_Mcu_Ganv_Sensor_Task_Without_tick(&sensor);
        Get_Normalize_For_User(&sensor, Normal);
        Digtal=Get_Digtal_For_User(&sensor);
        // Ƕƫ
        result_angle = CalculateNormalizedValue(Normal,1);
        //printf("Anolog %d-%d-%d-%d-%d-%d-%d-%d\r\n",Anolog[0],Anolog[1],Anolog[2],Anolog[3],Anolog[4],Anolog[5],Anolog[6],Anolog[7]);
			
        // 
        Motor_Control();
    }
}