#include "key.h"
#include "led.h"
#include "delay.h"
#include "uart.h"
#include "No_Mcu_Ganv_Grayscale_Sensor_Config.h"


/* 全局变量 */
volatile uint32_t last_key_time = 0;  // 上次按键时间戳
volatile uint8_t key_pressed = 0;     // 按键按下标志

uint8_t key_start_pressed=0;

/* 外部变量声明 */
extern unsigned short Anolog[8];      // 模拟量采样数组
extern unsigned short black[8];       // 黑场校准数据
extern unsigned short white[8];       // 白场校准数据  
extern No_MCU_Sensor sensor;          // 传感器数据结构体

// Group1的中断服务函数
void GROUP1_IRQHandler(void)
{
    // 读取Group1的中断寄存器并清除中断标志位
    uint32_t pending = DL_GPIO_getPendingInterrupt(GPIOA);
    
		if (pending == KEY_IN1_IIDX){
            /* 防抖处理 */
            if ((Tick - last_key_time) < DEBOUNCE_TIME_MS) {
                return;
            }
            
            /* 确认按键按下 */
            if (DL_GPIO_readPins(KEY_PORT, KEY_IN1_PIN) == 0) {
                key_pressed = 1;
                last_key_time = Tick;
            }
		}
		if(pending==KEY_IN2_IIDX){
			key_start_pressed=1;
		}
}