#include "PID.h"
#include "delay.h"

// ƫPID
int Kp_Yaw = 10;  // ϵ
int Ki_Yaw = 0;   // ϵ
int Kd_Yaw = 50;   // ΢ϵ

int Yaw_Now_Correct;      // ǰƫУֵ
int Integral_Yaw = 0;     // ۼ
int Err_Yaw = 0;          // ǰ
int LastErr_Yaw = 0;      // һ
int Output_Yaw = 0;       // PID
int result_angle = 0;     // ǶȽ
int max = 100;            // ޷ֵ

#define INTEGRAL_MAX 5    // 
#define INTEGRAL_MIN -5   // 

/**
  * @brief  ƫPID
  * @param  Target: ĿǶ
  */
void Pid_Yaw(float Target)
{
    Yaw_Now_Correct = result_angle;
    Err_Yaw = Target - Yaw_Now_Correct;
    
    // 
    Integral_Yaw += Err_Yaw;
    if (Integral_Yaw > INTEGRAL_MAX) Integral_Yaw = INTEGRAL_MAX;
    if (Integral_Yaw < INTEGRAL_MIN) Integral_Yaw = INTEGRAL_MIN;
    
    // PID
    Output_Yaw = ((Kp_Yaw * Err_Yaw) /1024) + 
                 ((Kd_Yaw * (Err_Yaw - LastErr_Yaw)) /1024) + 
                 ((Ki_Yaw * Integral_Yaw) /1024);
    
    LastErr_Yaw = Err_Yaw;
    
    // ޷
    if (Output_Yaw > max) Output_Yaw = max;
    if (Output_Yaw < -max) Output_Yaw = -max;
}