#include "L298N.h"
#include "stdlib.h"
// 
#define VMAX 90                // ٶ
#define VMIN 40								 // Сٶ
int K_V=33;									 // ϵ
// ȫֱ
int SpeedL;                    // ٶ
int SpeedR;                    // ٶ
int Speed_Set = 0;             // ׼ٶ
float Tarangle = 0;            // ĿǶ

int pwmR;
int pwmL;

// AƱ
volatile int16_t motorDuty_A = 100;  // ռձ (0-200), Ĭ100(ֹ)
volatile uint8_t pwmCounter_A = 0;   // PWM (0-199)

// BƱ  
volatile int16_t motorDuty_B = 100;  // ռձ (0-200), Ĭ100(ֹ)
volatile uint8_t pwmCounter_B = 0;   // PWM (0-199)

/**
 * @brief õAPWMռձ
 * @param duty: ռձ (0-200), 100Ϊֹ
 */
void Motor_SetDuty_A(int16_t duty) {
    if (duty > 200) duty = 200;
    if (duty < 0) duty = 0;
    motorDuty_A = duty;
}

/**
 * @brief õBPWMռձ  
 * @param duty: ռձ (0-200), 100Ϊֹ
 */
void Motor_SetDuty_B(int16_t duty) {
    if (duty > 200) duty = 200;
    if (duty < 0) duty = 0;  
	
    motorDuty_B = duty;
}

/**
 * @brief µAPWM
 */
void Motor_UpdatePWM_A() {
    pwmCounter_A = (pwmCounter_A + 1) % 200;
    
    if (motorDuty_A >= 100) {  // ת
        if (pwmCounter_A < motorDuty_A) {
            AIN1_OUT(0);  // תPWMߵƽ
            AIN2_OUT(1);
        } else {
            AIN1_OUT(1);  // ͵ƽ
            AIN2_OUT(0);
        }
    } else {  // ת
        if (pwmCounter_A < (200 - motorDuty_A)) {
            AIN1_OUT(1);
            AIN2_OUT(0);  // תPWMߵƽ
        } else {
            AIN1_OUT(0);
            AIN2_OUT(1);  // ͵ƽ
        }
    }
}
/**
 * @brief ʱжϴµPWM
 */
void TIMER_0_INST_IRQHandler(void) {
    Motor_UpdatePWM_A();
    Motor_UpdatePWM_B();
}

/**
 * @brief µBPWM
 */
void Motor_UpdatePWM_B() {
    pwmCounter_B = (pwmCounter_B + 1) % 200;
    
    if (motorDuty_B >= 100) {  // ת
        if (pwmCounter_B < motorDuty_B) {
            BIN1_OUT(1);  // תPWMߵƽ
            BIN2_OUT(0);
        } else {
            BIN1_OUT(0);  // ͵ƽ
            BIN2_OUT(1);
        }
    } else {  // ת
        if (pwmCounter_B < (200 - motorDuty_B)) {
            BIN1_OUT(0);
            BIN2_OUT(1);  // תPWMߵƽ
        } else {
            BIN1_OUT(1);
            BIN2_OUT(0);  // ͵ƽ
        }
    }
}

/**
 * @brief ʵֲٿƺPID
 */
void Motor_Control(void)
{
    extern int result_angle;      // Ƕƫ
    extern unsigned char Digtal;  // 
	
    // ݽǶƫ
    Pid_Yaw(Tarangle);
	
		//ٶԿ
    Speed_Set = VMAX - K_V * abs(result_angle)/1024;
	
    // ߼ͱ
    if (!(Digtal & 0x01)) {  // 0λߣ
        Speed_Set = VMIN;
        Output_Yaw = 60;  // ת
    } 
    else if (!(Digtal & 0x80)) {  // 7λߣ
        Speed_Set = VMIN;
        Output_Yaw = -60;   // ת
    }
    else if (Speed_Set < VMIN) {  // µٶޱ
        Speed_Set = VMIN;
    }
    
    // PWM
    pwmR = pwmL = Speed_Set;
    // ٿƣYawٶ
    SpeedR = (int)(pwmR + Output_Yaw);
    SpeedL = (int)(pwmL - Output_Yaw);
    // PWM޷
    SpeedR = (SpeedR > 100) ? 100 : ((SpeedR < -100) ? -100 : SpeedR);
    SpeedL = (SpeedL > 100) ? 100 : ((SpeedL < -100) ? -100 : SpeedL);
    
    // õPWM
    Motor_SetDuty_B(SpeedL + 100);
    Motor_SetDuty_A(SpeedR + 100);
}

